%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%% Volcano Curve Simulator ******* Matthew Unterman %%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Thomas Crowley %%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%load the data point db
load Matt_3090N.csv
%read in the three columns
file_matrix = Matt_3090N;

%If its a tropical strip, need to test for singularity multipliers
tropical_input = input('Is this a tropical strip input? (0 = N, 1 = Y)');
if tropical_input ==1
    tropical_NS = input('OK! Is this the 0-30N or 0-30S strip? (0 = 0-30N, 1 = 0-30S)');
end



read_year = file_matrix(:,1,:);
read_tropical_test = file_matrix(:,2,:);

read_flux = file_matrix(:,3,:);
start_year = read_year(1); %beginning year of the time series - this would be 800 for the first initialization (June, 2008)
total_length = length(file_matrix);
last_year = 1:length(file_matrix); %last year
total_years = ceil(file_matrix(length(file_matrix))-file_matrix(1)); %total number of years in the matrix rounded up in 3090N = 1192

aod_conversion_factor = 0.0115;             %Flux*conversion_factor = AOD
aod_multiplier_factor = 20;

critical_value = 18.2;                      %Units kg/km**2 - flux value that initiates scaling factors

%Full length of time-series in time-bins (3 steps per month, 36 per year)
time_series_matrix = 0:1:((round(2050)-800)*36);  %number of time bins in the entire matrix - extended to 2050 to hold all values up to 1991.46
time_series_matrix = zeros(1,length(time_series_matrix)); %make values all zero because no background state

time_series_length = 0:1:(10*36); %running matrix of 5 years in length

for total_run = 1:length(file_matrix); %iterate through eruptions
%for total_run = 10:10
    year_index = round((read_year(total_run)-800)*36); %location in the matrix of the erruption
    %get year
    %test for tropical
    %run stats based off of location
%read_tropical_test(1)=1;
    %%%%%%%%% CHECK IF TROPICAL AND ADJUST VARIABLES %%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%% Note: variables could have been compressed - they are set up
    %%%%%%%%% this way for easier top down reading
if tropical_input ==0
if read_tropical_test(total_run) ==1 || read_tropical_test(total_run) ==2 %%check to see if tropical or tropical UP and set values
    crowley_coef = 1.2;
    peak_time = 8;                              %months to reach plateau peak
    peak_retain = 3;
    efolding_time =1;
    efolding_duration=3;
    
           if read_year(total_run)==1257.7
              efolding_time=(1/2);
              efolding_duration=4;
           end

    
else %its a high latitude erruption
    crowley_coef = 1.3;
    peak_time = 3+(1/3); % 3.5 but due to 36 time bins, equalized
    peak_retain = 2; % 2.5 but due to 36 time bins, rounded down
    efolding_time = (2/3);
    efolding_duration=2;
end
    else %its a tropical strip
        %here: read_tropical_test is the flag variable to determine
        %multipliers
        if read_tropical_test(total_run)==3
                read_flux(total_run) =read_flux(total_run)*1.2;
                crowley_coef = 1.4;                             %this is a weighted eruption
                peak_time = 8;                              %months to reach plateau peak
                peak_retain = 3;
                efolding_time =1;
                efolding_duration=3;
        end
        if read_tropical_test(total_run)==4
                read_flux(total_run) =read_flux(total_run)*1.2;
                crowley_coef = 0.6;                         %this is a scaled eruption
                peak_time = 8;                              %months to reach plateau peak
                peak_retain = 3;
                efolding_time =1;
                efolding_duration=3;
        end
        if read_tropical_test(total_run)==5
                read_flux(total_run) =read_flux(total_run)*1.2;
                crowley_coef =1.2;                          %this is a bi-polar tropical eruption
                peak_time = 8;                              %months to reach plateau peak
                peak_retain = 3;
                efolding_time =1;
                efolding_duration=3;
        end
        if read_tropical_test(total_run)==6
               if tropical_NS ==0 %north slot uniques
                   if read_year(total_run)==854 || read_year(total_run) ==896.5 || read_year(total_run)==1831.7
                       read_flux(total_run) =read_flux(total_run)*1.2;
                       read_flux(total_run)=read_flux(total_run)/2;
                       crowley_coef=1.4;
                       peak_time=8;
                       peak_retain=3;
                       efolding_time=1;
                       efolding_duration=3;
                   end
                   if read_year(total_run)==1455.5
                       read_flux(total_run) =read_flux(total_run)*1.2;
                       crowley_coef=0.4;
                       peak_time=8;
                       peak_retain=3;
                       efolding_time=1;
                       efolding_duration=3;
                   end
                   if read_year(total_run)==1257.7
                       read_flux(total_run) =read_flux(total_run)*1.2;
                       crowley_coef=1.2;
                       peak_time=8;
                       peak_retain=3;
                       efolding_time=(1/2);
                       efolding_duration=4;
                   end
               end
               if tropical_NS ==1 %south slot uniques
                   if read_year(total_run)==854 || read_year(total_run) ==896.5 || read_year(total_run)==1831.7
                       read_flux(total_run) =read_flux(total_run)*1.2;
                       read_flux(total_run)=read_flux(total_run)/2;
                       crowley_coef=0.6;
                       peak_time=8;
                       peak_retain=3;
                       efolding_time=1;
                       efolding_duration=3;
                   end
                   if read_year(total_run)==1455.5
                       read_flux(total_run) =read_flux(total_run)*1.2;
                       crowley_coef=1.4;
                       peak_time=8;
                       peak_retain=3;
                       efolding_time=1;
                       efolding_duration=3;
                   end
                   if read_year(total_run)==1963
                       read_flux(total_run) =read_flux(total_run)*1.2;
                       crowley_coef=1.6;
                       peak_time=8;
                       peak_retain=3;
                       efolding_time=1;
                       efolding_duration=3;
                   end
                   if read_year(total_run)==1257.7
                       read_flux(total_run) =read_flux(total_run)*1.2;
                       crowley_coef=1.2;
                       peak_time=8;
                       peak_retain=3;
                       efolding_time=(1/2);
                       efolding_duration=2;
                   end
                   
               end
                %crowley_coef = 1.2;                         %this is a uniquely scaled eruption
                %peak_time = 8;                              %months to reach plateau peak
                %peak_retain = 3;
                %efolding_time =1;
                %efolding_duration=3;
    
        end %end uniqueness check
        
    end
    
        
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %Read in the flux value here
flux_value = read_flux(total_run);
%flux_value = 11.0;

plateau_value = flux_value * crowley_coef;  %Pinatubo would be 11.0 kg/km**2 * 1.2
plateau_time = (peak_time * 30)/10;         %Pinatubo would be 8*30 = 240/10 = 24 time steps
plateau_retain = (peak_retain *30)/10;      %Pinatubo peak would be retained 9 total time steps (3*30)/10 =9

interpolation = 1;                          %linear = 1;

%time_series_length = (((peak_time) + (peak_retain) + ((efolding_time*12)*efolding_duration))*30)/10; %total time steps



%NOTE: the conversion could be written in 1 line obviously, but for
%'code-reading' it has been broken up into its parts. cf conditionals

linear_ramp=1:plateau_value/plateau_time:plateau_value; %Pinatubo should reach 13.2 in 24 time steps linearly
    
%First: Get to the max peak
    for count = 1:length(linear_ramp)
        if linear_ramp(count) > critical_value  %determine if needs power correction
            linear_ramp(count) = linear_ramp(count)*aod_conversion_factor; %convert to aod for scaling
            linear_ramp(count) = linear_ramp(count)-(critical_value*aod_conversion_factor); %get the excess - in aod units
            linear_ramp(count) = linear_ramp(count)*aod_multiplier_factor;
            linear_ramp(count) = linear_ramp(count)^(2/3);
            linear_ramp(count) = linear_ramp(count)/aod_multiplier_factor;
            linear_ramp(count) = linear_ramp(count)+(critical_value*aod_conversion_factor);
            linear_ramp(count) = linear_ramp(count)/aod_conversion_factor; %get back to flux
            %linear_ramp(count) = critical_value + (linear_ramp(count)-critical_value)^(2/3);
        end
        time_series_length(count) = linear_ramp(count);
    end                                     %Fill the first 1 to length(linear_ramp) elements of time_series_matrix and fill them with values of linear_ramp

 %Second: Maintain the peak for time = plateau_retain
     
    for count2 = length(linear_ramp)+1:length(linear_ramp)+plateau_retain+1 %from the time it reaches peak, for the duration of peak retainment
        if plateau_value > critical_value   %determine if needs power correction
            time_series_length(count2) = plateau_value*aod_conversion_factor;
            time_series_length(count2) = time_series_length(count2)-(critical_value*aod_conversion_factor);
            time_series_length(count2) = time_series_length(count2)*aod_multiplier_factor;
            time_series_length(count2) = time_series_length(count2)^(2/3);
            time_series_length(count2) = time_series_length(count2)/aod_multiplier_factor;
            time_series_length(count2) = time_series_length(count2)+(critical_value*aod_conversion_factor);
            time_series_length(count2) = time_series_length(count2)/aod_conversion_factor;
            %time_series_matrix(count2) = critical_value+(plateau_value-critical_value)^(2/3);
        else   
        time_series_length(count2) = plateau_value; %flat top maxed out at plateau_value for duration of plateau retain
        end
        
    end

 %Third: e-folding decay for remaining steps
 step = 1;
    for count3 = length(linear_ramp)+plateau_retain+2:length(time_series_length); %tack on the efolding time duration
        %for count3 = length(linear_ramp)+plateau_retain+2:(length(linear_ramp)+plateau_retain+2)+(efolding_duration*36); %tack on the efolding time duration
        %time_series_length(count3) = plateau_value*(((plateau_value*1/exp(1))/plateau_value)^(step/36*efolding_time)); %first e-folding time where 36*efolding_time is the number of steps
       
        %value = plateau_value*(((plateau_value*1/exp(1))/plateau_value)^(step/36*efolding_time));
         %value=time_series_length(count2)*(exp(-(count3-count2)/(36*efolding_time)));
         value=plateau_value*(exp(-(step)/(36*efolding_time)));
         time_series_length(count3) = value;
        if time_series_length(count3) > critical_value %determine if needs power correction
            time_series_length(count3) = value*aod_conversion_factor;
            time_series_length(count3) = time_series_length(count3)-(critical_value*aod_conversion_factor);
            time_series_length(count3) = time_series_length(count3)*aod_multiplier_factor;
            time_series_length(count3) = time_series_length(count3)^(2/3);
            time_series_length(count3) = time_series_length(count3)/aod_multiplier_factor;
            time_series_length(count3) = time_series_length(count3)+(critical_value*aod_conversion_factor);
            time_series_length(count3) = time_series_length(count3)/aod_conversion_factor;
                        
        end
        if step > (efolding_duration+1)*36 %simulate zeroes after efolding duration has elapsed
            time_series_length(count3) = 0.0;
        end
        
        
        step = step+1;
    end


%add it to the overall matrix
for count4 = 1:length(time_series_length)
    time_series_matrix(year_index+count4) = time_series_matrix(year_index+count4)+time_series_length(count4);
    %time_series_matrix(((read_year(total_run)-800)*36)+count4) is the
    %start date of the eruption at count4 = 1
end
    
  %time_series_matrix(((read_year(total_run)-800)*36)+count4)+time_series_length(count4);  
    
%time_series_matrix_aod = time_series_matrix.*0.011;
end



year_column2 = 0:1:length(time_series_matrix)-1;
year_column = (year_column2./36)+800;
%gets the x-axis back to years
plot(year_column,time_series_matrix);

%convert flux mass to aod
aod_converted = time_series_matrix.*0.011;


%reff = 0.84833.*(aod_converted).^(0.33167);
reff = aod_converted.^(1/3);
%make all values of reff below 0.2 set to 0.2 due to model capabilities
for reff_count = 1:length(reff)
    if reff(reff_count) <0.2
        reff(reff_count)=0.2;
    end
end



xlim([800 2000]); %need tails.

  %final_plot_point = (2000-800)*36;
  %xlim([0 final_plot_point]);
  %plot(time_series_matrix);
  %x_axis_holder = get(gca,'xtick');
  %new_x_axis = round((x_axis_holder/36)+800);
  %set(gca,'xticklabel',new_x_axis);
  



% efolding formula 13.2*((0.3682)^(36/36)) where .3682 is (13.2*1/e)/13.2
% for percentage of decay