### Functions
## written by Alan B. Seo 

reclassLULC <- function(LULC, rcl, columns) {
    tar <- org <- LULC@data
    
    # tar[] <- NA
    
    rcl <- rcl[!is.na(rcl[,1]),]
    if (ncol(rcl) > 2) { 
        
        additionalInfo <- matrix(NA, nrow=nrow(tar), ncol=12)
        
        
        colnames(additionalInfo) <- c("Mgmt2009", "Mgmt2010", "Mgmt2011", "DblCrp2009",  "DblCrp2010",  "DblCrp2011", "Mixed2009", "Mixed2010","Mixed2011", "Note2009", "Note2010", "Note2011")
        
        columns.qa <- c("qa2009", "qa2010", "qa2011")
        
        #     str(tar[,columns.qa])
    }
    
    for (i in 1:length(columns)) { 
        
        for (j in 1:nrow(rcl)) {
            idx1 <- org[,columns[i]] == as.character(rcl$original.types[j])
            idx1[is.na(idx1)] <- FALSE
            
            tar[idx1, columns[i]] <- as.character(rcl$replacement.types[j])
            
            # additionalInfo[idx1, (i-1) + c(1,4,7)] <- as.character(rcl[j, 3:5]) 
            # Not working in this way 
            
            if (ncol(rcl) > 2) { 
                
                additionalInfo[idx1, (i-1) + 1] <- as.character(rcl[j, 3]) 
                additionalInfo[idx1, (i-1) + 4] <- as.character(rcl[j, 4]) 
                additionalInfo[idx1, (i-1) + 7] <- as.character(rcl[j, 5]) 
                additionalInfo[idx1, (i-1) + 10] <- as.character(rcl[j, 6]) 
                
                # Update QA info
                
                if (!is.na(rcl[j, 7])) { 
                    tar[idx1,columns.qa[i]] <- as.character(rcl[j, 7])
                    #               print(tar[idx1,columns.qa[i]])
                    #               stop()
                }
            }
        }
        
        # No data & NA
        
        idx.na <- is.na(org[,columns[i]])
        
        tar[idx.na, columns[i]] <- "NA" # Character 'NA'
        
        if (ncol(rcl) > 2) { 
            
            tar[idx.na, columns.qa[i]] <- as.character(rcl[rcl[,1]=="no data", 7]) # QA 
            
            
            additionalInfo[idx.na, (i-1) + 1] <- as.character(rcl[rcl[,1]=="no data", 3]) 
            additionalInfo[idx.na, (i-1) + 4] <- as.character(rcl[rcl[,1]=="no data", 4]) 
            additionalInfo[idx.na, (i-1) + 7] <- as.character(rcl[rcl[,1]=="no data", 5]) 
            additionalInfo[idx.na, (i-1) + 10] <- as.character(rcl[rcl[,1]=="no data", 6]) 
        }
        
    }
    if (ncol(rcl) > 2) { 
        
        LULC@data <- cbind(tar, additionalInfo, stringsAsFactors=F)
        
    } else { 
        LULC@data <- cbind(tar, stringsAsFactors=F)
        
    }
    return(LULC)
}