from SelectWCB_zarr import *
import argparse


class Unbuffered(object):
   def __init__(self, stream):
       self.stream = stream
   def write(self, data):
       self.stream.write(data)
       self.stream.flush()
   def writelines(self, datas):
       self.stream.writelines(datas)
       self.stream.flush()
   def __getattr__(self, attr):
       return getattr(self.stream, attr)

parser = argparse.ArgumentParser()
parser.add_argument("-p",action="store",dest="Path",help="Base folder",required=True, type=str)
parser.add_argument("-y",action="store",dest="Year",help="Year",required=True, type=int)
opt = parser.parse_args()

if opt.Year < 1947:
    period = '194001-194703'
elif opt.Year < 1954:
    period = '194701-195403'
elif opt.Year < 1961:
    period = '195401-196103'
elif opt.Year < 1968:
    period = '196101-196803'
elif opt.Year < 1975:
    period = '196801-197503'
elif opt.Year < 1982:
    period = '197501-198203'
elif opt.Year < 1989:
    period = '198201-198903'
elif opt.Year < 1996:
    period = '198901-199603'
elif opt.Year < 2003:
    period = '199601-200303'
elif opt.Year < 2010:
    period = '200301-201003'
elif opt.Year < 2017:
    period = '201001-201703'
elif opt.Year < 2024:
    period = '201701-202403'

sel_dict = {
  'paths_to_directories' : opt.Path+'/'+period,
  'period' : [[opt.Year,6,1,0],[opt.Year,9,1,0]],
  'times' : [[opt.Year,6],[opt.Year,7],[opt.Year,8]],
  'time_interval' : 48,
}


griddata,wcb_frac = select_particles_grid(sel_dict)
print('Writing data to WCB_JJA_%i.nc' %(opt.Year))
save_netcdf(griddata,wcb_frac, 'WCB_JJA_%i.nc' %(opt.Year),sel_dict)
print('Writing finished')
gc.collect()


sel_dict = {
  'paths_to_directories' : opt.Path+'/'+period,
  'period' : [[opt.Year,12,1,0],[opt.Year+1,3,1,0]],
  'times' : [[opt.Year,12],[opt.Year+1,1],[opt.Year+1,2]],
  'time_interval' : 48,
}


griddata,wcb_frac = select_particles_grid(sel_dict)
print('Writing data to WCB_DJF_%i.nc' %(opt.Year))
save_netcdf(griddata,wcb_frac, 'WCB_DJF_%i.nc' %(opt.Year),sel_dict)
print('Writing finished')
gc.collect()
    #print('Close files...')
    #for key in pd.keys():
    #    pd[key]._pd.close()
    #print('Files closed')
