from SelectParticles_zarr import *
import argparse


class Unbuffered(object):
   def __init__(self, stream):
       self.stream = stream
   def write(self, data):
       self.stream.write(data)
       self.stream.flush()
   def writelines(self, datas):
       self.stream.writelines(datas)
       self.stream.flush()
   def __getattr__(self, attr):
       return getattr(self.stream, attr)

parser = argparse.ArgumentParser()
parser.add_argument("-b",action="store",dest="Path",help="Base folder",required=True, type=str)
parser.add_argument("-p",action="store",dest="Period",help="Period",required=False, type=str)
parser.add_argument("-y",action="store",dest="Year",help="Year",required=True, type=int)

opt = parser.parse_args()

if opt.Period is None:
    if opt.Year <= 1947:
        opt.Period = '194001-194703'
    elif opt.Year <= 1954:
        opt.Period = '194701-195403'
    elif opt.Year <= 1961:
        opt.Period = '195401-196103'
    elif opt.Year <= 1968:
        opt.Period = '196101-196803'
    elif opt.Year <= 1975:
        opt.Period = '196801-197503'
    elif opt.Year <= 1982:
        opt.Period = '197501-198203'
    elif opt.Year <= 1989:
        opt.Period = '198201-198903'
    elif opt.Year <= 1996:
        opt.Period = '198901-199603'
    elif opt.Year <= 2003:
        opt.Period = '199601-200303'
    elif opt.Year <= 2010:
        opt.Period = '200301-201003'
    elif opt.Year <= 2017:
        opt.Period = '201001-201703'
    elif opt.Year <= 2024:
        opt.Period = '201701-202403'

sel_dict = {
  'paths_to_directories' : opt.Path,
  'period' : opt.Period,
  'year' : opt.Year,
  'month' : "03",
  'period_select_hours' : 24,
  'period_analyse_hours' : 745,
  'time_interval' : 120,
  'fields_to_load' : (['lon','lat','z'])
}


d_output = select_particles_grid(sel_dict)
print('Writing data to Energy_%i.nc' %(opt.Year))
save_netcdf(d_output, 'Energy_%i.nc' %(opt.Year),sel_dict)
print('Writing finished')
gc.collect()
    #print('Close files...')
    #for key in pd.keys():
    #    pd[key]._pd.close()
    #print('Files closed')
