from ComputeDensity_zarr import *
import argparse


class Unbuffered(object):
   def __init__(self, stream):
       self.stream = stream
   def write(self, data):
       self.stream.write(data)
       self.stream.flush()
   def writelines(self, datas):
       self.stream.writelines(datas)
       self.stream.flush()
   def __getattr__(self, attr):
       return getattr(self.stream, attr)

sys.stdout = Unbuffered(sys.stdout)

parser = argparse.ArgumentParser()
parser.add_argument("-p",action="store",dest="Period",help="Period",required=True, type=str)
parser.add_argument("-y",action="store",dest="Year",help="Year",required=True, type=str)
parser.add_argument("-m",action="store",dest="Month",help="Month to simulate (01-12)",required=False, type=str)
opt = parser.parse_args()
compute_density(path_to_LARA='/jetfs/scratch/lbakels/LARA_zarr/',period=opt.Period,year=opt.Year,month=opt.Month)
